#include <GUIConstants.au3>
#include <GDIPlus.au3>
#include <Math.au3>

$hGUI = GUICreate("scintilla4evr's Cookbook of Examples - Text on Curve (Single) (2016)", 600, 400)
GUISetBkColor(0xFFFFFF)
GUISetState()

_GDIPlus_Startup()

$hGpx = _GDIPlus_GraphicsCreateFromHWND($hGUI)
$hBufBmp = _GDIPlus_BitmapCreateFromScan0(600, 400)
$hBufGpx = _GDIPlus_ImageGetGraphicsContext($hBufBmp)
_GDIPlus_GraphicsSetSmoothingMode($hBufGpx, 5)
_GDIPlus_GraphicsClear($hBufGpx, 0xFFFFFFFF)

$hPath = _GDIPlus_PathCreate()

$hFamily = _GDIPlus_FontFamilyCreate("Arial")
$tLayout = _GDIPlus_RectFCreate()

_GDIPlus_PathAddString($hPath, "Lorem ipsum", $tLayout, $hFamily, 0, 72)

$hCurve = _GDIPlus_PathCreate()
_GDIPlus_PathAddBezier($hCurve, 100, 80, 200, 120, 360, 56, 430, 90)

$hCurvedText = _GDIPlus_PathCreate()
_CurveText($hPath, $hCurve, $hCurvedText)

_Render()

While 1
	Switch GUIGetMsg()
		Case $GUI_EVENT_CLOSE
			ExitLoop
	EndSwitch
WEnd

_GDIPlus_PathDispose($hCurvedText)
_GDIPlus_PathDispose($hCurve)

_GDIPlus_FontFamilyDispose($hFamily)
_GDIPlus_PathDispose($hPath)

_GDIPlus_GraphicsDispose($hBufGpx)
_GDIPlus_BitmapDispose($hBufBmp)
_GDIPlus_GraphicsDispose($hGpx)

_GDIPlus_Shutdown()

Func _Render()
	_GDIPlus_GraphicsClear($hBufGpx, 0xFFFFFFFF)

	_GDIPlus_GraphicsDrawPath($hBufGpx, $hCurve)
	_GDIPlus_GraphicsFillPath($hBufGpx, $hCurvedText)

	_GDIPlus_GraphicsDrawImage($hGpx, $hBufBmp, 0, 0)
EndFunc

Func _CurveText($hText, $hCurve, $hOut)
	_GDIPlus_PathFlatten($hCurve, 0.01) ; Less points = faster calculation

	$aTxtBounds = _GDIPlus_PathGetWorldBounds($hText)

	$hSub = _GDIPlus_PathCreate()

	$hIter = _GDIPlus_PathIterCreate($hText)

	For $i = 1 To _GDIPlus_PathIterGetSubpathCount($hIter)
		_GDIPlus_PathReset($hSub)
		_GDIPlus_PathIterNextSubpathPath($hIter, $hSub)

		$aPoints = _GDIPlus_PathGetData($hSub)
		For $n = 1 To $aPoints[0][0]
			$x = $aPoints[$n][0]-$aTxtBounds[0]
			$y = $aPoints[$n][1]-$aTxtBounds[1]

			$x = _Min($x/$aTxtBounds[2], 1)

			_MapXYToCurve($hCurve, $x, $y)

			$aPoints[$n][0] = $x
			$aPoints[$n][1] = $y
		Next
		$hTrans = _GDIPlus_PathCreate2($aPoints)
		_GDIPlus_PathAddPath($hOut, $hTrans, False)
		_GDIPlus_PathDispose($hTrans)
	Next

	_GDIPlus_PathIterDispose($hIter)

	_GDIPlus_PathDispose($hSub)
EndFunc

; $fX ∈ <0, 1>
Func _MapXYToCurve($hPath, ByRef $fX, ByRef $fY)
	Local $i, $aBounds, $aPoints

	$aBounds = _GDIPlus_PathGetWorldBounds($hPath)
	$aPoints = _GDIPlus_PathGetPoints($hPath)

	For $i = 2 To $aPoints[0][0]
		$x1 = ($aPoints[$i-1][0]-$aBounds[0])/$aBounds[2]
		$x2 = ($aPoints[$i][0]-$aBounds[0])/$aBounds[2]

		If _InRange($fX, $x1, $x2) Then
			$x = $fX-$x1

			$y1 = $aPoints[$i-1][1]
			$y2 = $aPoints[$i][1]

			$fX = $aBounds[0] + $fX*$aBounds[2]
			$fY += _Lerp($x, $y1, $y2)

			ExitLoop
		EndIf
	Next
EndFunc

Func _InRange($x, $a, $b)
	If $a <= $x And $x <= $b Then Return 1
	Return 0
EndFunc

Func _Lerp($x, $a, $b)
	Return $x*($b-$a) + $a
EndFunc
